#include <msp430.h> 
#include <stdint.h>

#include "RF1A.h"
#include "RF_Connection.h"
#include "PMM.h"
#include "ports.h"
#include "RFconfig.h"

#define BUFFER_SIZE		1	// maximum size of data sent by rf

#define SLIP_END			0xC0
#define SLIP_ESC			0xDB
#define SLIP_ESC_END		0xDC
#define SLIP_ESC_ESC		0xDD

#define PWM_PERIOD		255
#define DELAY 10000 //30ms  


volatile uint8_t buffer[BUFFER_SIZE];
volatile uint8_t temp[NB_BANGLES][2];
volatile uint8_t fin[NB_BANGLES][NB_BANGLES-1];

//useless
void packet_received(void)
{

}

// Any other commands are for RSSI measurement
void send_cmd(void)
{
  buffer[0] = 0xFF;
  rf_transmit((uint8_t *)buffer, 2);
}

int main(void)
{
  unsigned char chann=0x00;
  WDTCTL = WDTPW + WDTHOLD;   // Stop WDT
  rf_init();
  ReceiveOff();
  _BIS_SR(GIE);	

  while(1)
    {
      ChangeChannel(chann);
      send_cmd();
      if(chann>=69)
	{
	  chann=0x00;
	}
      else
	{
	  chann++;
	}
      __delay_cycles(DELAY);
    }
  return 0;
}

